﻿//If the SDK namespace object is not defined, create it.
if (typeof (MCS) == "undefined")
{ MCS = {}; }
// Create Namespace container for functions in this library;
if (typeof (MCS.PS_Buttons) == "undefined") {
    MCS.PS_Buttons = {};
}

//Page Scope Variables
MCS.PS_Buttons.Async = false;

//HELPER - Unsupported method of re-creating Multi-select Lookup window in order to Create a different type of record than you are looking up
MCS.PS_Buttons.buildshowStandardDialog = function (entityName, viewName) {
    var otcCode = MCS.cvt_Common.getObjectTypeCode(entityName);

    if (MCS.ParticipatingSite.Site != null) {
        var customViewId = MCS.ParticipatingSite.Site[0].id;
        var customView;

        if (MCS.ParticipatingSite.Side == "Provider" && MCS.ParticipatingSite.Modality == "SFT") {
            if (viewName == "Resources By Site") {
                //Prevent users from adding Provider Side Resources
                alert("Per Business Rules, you should enter only a Provider or Provider Group on this SFT Resource Package.");
                return;
            } 
        }
        else if (MCS.ParticipatingSite.Side == "Patient" && MCS.ParticipatingSite.isGroup) {
            if (viewName != "Resource Groups By Site") {
                //Prevent users from adding Patient Side Resources or Users
                alert("Per Business Rules, you should enter Patient Side Paired Groups on this Group Resource Package.");
                return;
            }
        }
        
        switch (viewName) {
            case "Users By Site":
                // object located in Lookup.js : function CustomView(id, iRecordTypeId, sName, sFetchXml, sLayoutXml)
                customView = new CustomView(customViewId, otcCode, "Users By Site", getUserFetchXml(MCS.ParticipatingSite.Site), getUserLayout(otcCode));
                break;
            case "Resource Groups By Site":
                if (MCS.ParticipatingSite.Side == "Patient" && MCS.ParticipatingSite.Group)
                    customView = new CustomView(customViewId, otcCode, "Paired Resource Groups By Site", getResourceGroupFetchXml(MCS.ParticipatingSite.Site, true), getResourceGroupLayout(otcCode));
                else
                    customView = new CustomView(customViewId, otcCode, "Resource Groups By Site", getResourceGroupFetchXml(MCS.ParticipatingSite.Site, false), getResourceGroupLayout(otcCode));
                break;
            case "Resources By Site":
                customView = new CustomView(customViewId, otcCode, "Resources By Site", getResourceFetchXml(MCS.ParticipatingSite.Site), getResourceLayout(otcCode));
                break;
        }
        
        // object located in Lookup.js : function LookupArgsClass()
        // use the args object when passing complex objects to the openStdDlg()
        var args = new LookupArgsClass;

        // limit the list of Views to only the custom view
        args.customViews = new Array(customView);

        // located in Global.js: Mscrm.CrmUri.create
        var oUrl = Mscrm.CrmUri.create("/_controls/lookup/lookupinfo.aspx");
        oUrl.get_query()["LookupStyle"] = "multi";
        oUrl.get_query()["browse"] = "0";
        oUrl.get_query()["objecttypes"] = otcCode;

        // set the default view to the custom view created above
        oUrl.get_query()["DefaultViewId"] = customViewId;

        // generic object that contains the height and width
        var oFeatures = { width: 600, height: 700 };

        // Fixed for CRM2015
        var lookupItems = new Mscrm.CrmDialog(oUrl, args, oFeatures.width, oFeatures.height);
        return lookupItems;
    }
};


MCS.PS_Buttons.BuildRelationshipExisting = function (selectedControl) {
    alert("Resource Filtered Search Button clicked. Still under development.");
    var editable = MCS.PS_Buttons.CheckForScheduled();
    if (editable)
        MCS.ParticipatingSite.LinkResource();
    else
        alert("Participating Site must be in a status of Can Be Scheduled = 'No' in order to add a Scheduling Resource.");
};

//Called By Ribbon Button - Add Resource
MCS.PS_Buttons.BuildRelationshipResourceBySite = function (selectedControl) {
    var editable = MCS.PS_Buttons.CheckForScheduled();
    if (editable)
        MCS.PS_Buttons.BuildRelationshipResourceRunner("mcs_resource", selectedControl);
    else
        alert("Participating Site must be in a status of Can Be Scheduled = 'No' in order to add a Scheduling Resource.");  
};
//Called by Ribbon Button - Add Resource Groups
MCS.PS_Buttons.BuildRelationshipResourceGroupBySite = function (selectedControl) {
    var editable = MCS.PS_Buttons.CheckForScheduled();
    if (editable)
        MCS.PS_Buttons.BuildRelationshipResourceRunner("mcs_resourcegroup", selectedControl);
    else
        alert("Participating Site must be in a status of Can Be Scheduled = 'No' in order to add a Scheduling Resource.");
};
// Called by Ribbon Button - Add Users
MCS.PS_Buttons.BuildRelationshipUserBySite = function (selectedControl) {
    var editable = MCS.PS_Buttons.CheckForScheduled();
    if (editable)
        MCS.PS_Buttons.BuildRelationshipUserRunner(selectedControl);
    else
        alert("Participating Site must be in a status of Can Be Scheduled = 'No' in order to add a Scheduling Resource.");
};

//HELPER - Add User by Site (Patient or Provider)
MCS.PS_Buttons.BuildRelationshipUserRunner = function (selectedControl) {
    var schedulingResourceType = (MCS.ParticipatingSite.Side == "Patient") ? 3 : 2;
    var resourceType = (MCS.ParticipatingSite.Side == "Patient") ? 100000000 : 99999999;
    var lookupItems = MCS.PS_Buttons.buildshowStandardDialog('systemuser', "Users By Site");

    lookupItems.setCallbackReference(function (results) {
        if ((results != null) && (results != undefined)) {
            var returnedItems = results;
            if (typeof (results) == "string")
                returnedItems = JSON.parse(results);
            if (returnedItems != null) {
                for (i = 0; i < returnedItems.items.length; i++) {
                    var systemUser = {
                        'cvt_name': returnedItems.items[i].name,
                        'cvt_schedulingresourcetype': { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.OptionSetValue" }, Value: schedulingResourceType },
                        'cvt_resourcetype': { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.OptionSetValue" }, Value: resourceType },
                        'cvt_participatingsite': { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.EntityReference" }, Id: MCS.ParticipatingSite.EntityId, LogicalName: "cvt_participatingsite" },
                        'cvt_user': { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.EntityReference" }, Id: returnedItems.items[i].id, LogicalName: returnedItems.items[i].typename }
                    };
                    CrmRestKit.Create("cvt_schedulingresource", systemUser, MCS.PS_Buttons.Async);
                }
                Xrm.Page.getControl("subgrid_SchedulingResources").refresh();
                //selectedControl.refresh();
            }
        }
        else
            return null;
    });
    lookupItems.show();
};
//HELPER - Add Resource by Site (Patient or Provider AND Resource or Resource Group)
MCS.PS_Buttons.BuildRelationshipResourceRunner = function (entityName, selectedControl) {
    //Fields to make this function robust
    var siteField = 'mcs_RelatedSiteId';
    var SchedulingResourceType = 1;
    var title = "Resources";

    if (entityName == "mcs_resourcegroup") {
        siteField = 'mcs_relatedSiteId';
        SchedulingResourceType = 0;
        title = "Resource Groups";
    }
    var lookupItems = MCS.PS_Buttons.buildshowStandardDialog(entityName, title + " By Site");
    lookupItems.setCallbackReference(function (results) {
        if ((results != null) && (results != undefined)) {
            var returnedItems = results;
            if (typeof (results) == "string")
                returnedItems = JSON.parse(results);
            if (returnedItems != null) {
                for (i = 0; i < returnedItems.items.length; i++) {
                    var ResourceId = returnedItems.items[i].id;
                    var resourcename, type, relatedSite, relatedSiteName;
                    CrmRestKit.Retrieve(entityName, ResourceId, ['mcs_name', 'mcs_Type', siteField], MCS.PS_Buttons.Async)
                    .fail(function (err) { alert("Failed retrieved" + MCS.cvt_Common.RestError(err)); })
                    .done(function (data) {
                        resourcename = data.d.mcs_name;
                        type = data.d.mcs_Type.Value;
                        relatedSite = entityName == "mcs_resourcegroup" ? data.d.mcs_relatedSiteId : data.d.mcs_RelatedSiteId;
                    });
                    var newResource = {
                        'cvt_name': returnedItems.items[i].name,
                        'cvt_schedulingresourcetype': { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.OptionSetValue" }, Value: SchedulingResourceType },
                        'cvt_resourcetype': { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.OptionSetValue" }, Value: type },
                        'cvt_participatingsite': { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.EntityReference" }, Id: MCS.ParticipatingSite.EntityId, LogicalName: "cvt_participatingsite" }
                    };
                    var selectedID = { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.EntityReference" }, Id: ResourceId, LogicalName: returnedItems.items[i].typename };

                    if (entityName == "mcs_resourcegroup")
                        newResource.cvt_tmpresourcegroup = selectedID;
                    else
                        newResource.cvt_tmpresource = selectedID;

                    CrmRestKit.Create("cvt_schedulingresource", newResource, MCS.PS_Buttons.Async)
                    .fail(function (err) {
                        alert(MCS.cvt_Common.RestError(err));
                    })
                    .done(function () {
                        //Nothing here for now. Moved the Subgrid Refresh outside of loop to only run once all resources are created.               
                    });
                }
                Xrm.Page.getControl("subgrid_SchedulingResources").refresh();
                //selectedControl.refresh();
            }
        }
        else
            return null;
    });
    lookupItems.show();
};

MCS.PS_Buttons.CheckForScheduled = function () {
    if (Xrm.Page.getAttribute("cvt_scheduleable").getValue() == true)
        return false;
    else
        return true;
};

MCS.PS_Buttons.buildSiteConditions = function (site, type) {
    var siteXml = '';
    switch (type) {
        case "U":
            siteXml = '<condition attribute="cvt_site" operator="in">';
            break;
        default:
            siteXml = '<condition attribute="mcs_relatedsiteid" operator="in">';
            break;
    }
    siteXml += '<value uiname="' + MCS.cvt_Common.formatXML(site[0].mcs_name) + '" uitype="mcs_site">' + site[0].id + '</value></condition>';

    return siteXml;
};
//HELPER - creates the fetchXML to be used in grid views
function getResourceGroupFetchXml(site, isAllReqd) {
    var columns = [
   'mcs_name',
   'mcs_type',
   'mcs_relatedsiteid',
   'modifiedon',
   'createdon',
   'mcs_resourcegroupid'
    ];
    var conditions = [];

    if (isAllReqd) {
        conditions = [
            '<condition attribute="statecode" operator="eq" value="0"/>',
            '<condition attribute="mcs_type" operator="eq" value="917290000"/>',
             MCS.PS_Buttons.buildSiteConditions(site, "RG")
        ];
    }
    else {
        conditions = [
            '<condition attribute="statecode" operator="eq" value="0"/>',
             MCS.PS_Buttons.buildSiteConditions(site, "RG")
        ];
    }

    fetchXml = MCS.cvt_Common.CreateFetch('mcs_resourcegroup', columns, conditions, ['mcs_name', false]);

    return fetchXml;
};
function getResourceFetchXml(site) {

    var columns = [
       'mcs_resourceid',
       'mcs_name',
       'createdon'
    ];

    var conditions = [
        '<condition attribute="statecode" operator="eq" value="0"/>',
         MCS.PS_Buttons.buildSiteConditions(site, "R")
    ];

    fetchXml = MCS.cvt_Common.CreateFetch('mcs_resource', columns, conditions, ['mcs_name', false]);

    return fetchXml;
};
function getUserFetchXml(site) {
    fetchXml = '<fetch version="1.0" output-format="xml-platform" mapping="logical" distinct="false"><entity name="systemuser"><attribute name="fullname"/><attribute name="businessunitid"/><attribute name="cvt_type"/><attribute name="domainname"/><attribute name="jobtitle"/><attribute name="internalemailaddress"/><attribute name="modifiedon"/><attribute name="cvt_site"/><attribute name="cvt_facility"/><attribute name="systemuserid"/><order attribute="fullname" descending="false"/><filter type="and"><condition attribute="isdisabled" operator="eq" value="0"/><condition attribute="accessmode" operator="ne" value="3"/>';
    fetchXml += MCS.PS_Buttons.buildSiteConditions(site, "U");
    fetchXml += '</filter><link-entity name="team" from="teamid" to="cvt_primaryteam" visible="false" link-type="outer" alias="a_8f34fae9459de2118b0978e3b511a629"><attribute name="name"/></link-entity></entity></fetch>';
    return fetchXml;
};
//HELPER - sets the FetchXML view layout
function getResourceGroupLayout(otc) {
    return '<grid name="resultset" object="' + otc + '" jump="mcs_name" select="1" icon="0" preview="0"><row name="result" id="mcs_resourcegroupid"><cell name="mcs_name" width="300" /><cell name="mcs_relatedsiteid" width="300" /><cell name="mcs_type" width="150" /><cell name="modifiedon" width="125" /><cell name="createdon" width="125" /></row></grid>';
};
function getResourceLayout(otc) {
    return '<grid name="resultset" object="' + otc + '" jump="mcs_name" select="1" icon="0" preview="0"><row name="result" id="mcs_resourceid"><cell name="mcs_name" width="300" /><cell name="mcs_relatedsiteid" width="200" /><cell name="mcs_type" width="100" /><cell name="mcs_businessunitid" width="100" /><cell name="ownerid" width="150" /><cell name="modifiedon" width="125" /><cell name="createdon" width="125" /></row></grid>';
};
function getUserLayout(otc) {
    return '<grid name="resultset" object="8" jump="fullname" select="1" icon="0" preview="0"><row name="result" id="systemuserid"><cell name="fullname" width="200" /><cell name="jobtitle" width="150" /><cell name="domainname" width="200" /><cell name="internalemailaddress" width="150" /><cell name="cvt_type" width="125" /><cell name="cvt_facility" width="150" /><cell name="cvt_site" width="200" /><cell name="a_8f34fae9459de2118b0978e3b511a629.name" width="150" disableSorting="1" /><cell name="businessunitid" width="150" /><cell name="modifiedon" width="100" /></row></grid>';
};